/////////////////////////////////////////////////////////////////////////
///@system QuantDo Platform
///@company ϺͶƼ޹˾
///@file QdFtdcMduserApi.h
///@brief ˿ͻ˽ӿ
///@history 
///20130520	һ	ļ
/////////////////////////////////////////////////////////////////////////

#ifndef QD_FTDCMDUSERAPI_H
#define QD_FTDCMDUSERAPI_H

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "QdFtdcUserApiStruct.h"

#if defined(ISLIB) && defined(WIN32)
#ifdef LIB_MDUSER_API_EXPORT
#define MDUSER_API_EXPORT __declspec(dllexport)
#else
#define MDUSER_API_EXPORT __declspec(dllimport)
#endif
#else
#define MDUSER_API_EXPORT 
#endif

class CQdFtdcMduserSpi
{
public:
	///ͻ뽻׺̨ͨʱδ¼ǰ÷á
	virtual void OnFrontConnected(){};
	
	///ͻ뽻׺̨ͨӶϿʱ÷áAPIԶӣͻ˿ɲ
	///@param nReason ԭ
	///        0x1001 ʧ
	///        0x1002 дʧ
	///        0x2001 ʱ
	///        0x2002 ʧ
	///        0x2003 յ
	virtual void OnFrontDisconnected(int nReason){};
		
	///ʱ档ʱδյʱ÷á
	///@param nTimeLapse ϴνձĵʱ
	virtual void OnHeartBeatWarning(int nTimeLapse){};
	
	///Ļصʼ֪ͨAPIյһĺȵñȻǸĻصǱĻص֪ͨ
	///@param nTopicID 루˽ȣ
	///@param nSequenceNo 
	virtual void OnPackageStart(int nTopicID, int nSequenceNo){};
	
	///Ļص֪ͨAPIյһĺȵñĻصʼ֪ͨȻǸĻصñ
	///@param nTopicID 루˽ȣ
	///@param nSequenceNo 
	virtual void OnPackageEnd(int nTopicID, int nSequenceNo){};

	//ಥӿ add by zbz 20150304
	virtual void  OnMultiHeartbeat(char *CurrTime,char *MultiCastIP) {};
	
	//㲥յֵʱ򣬻صãqmdata
	virtual void UdpMarketData(CQdFtdcDepthMarketDataField *qmdata){};

	///Ӧ
	virtual void OnRspError(CQdFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///û¼Ӧ
	virtual void OnRspUserLogin(CQdFtdcRspUserLoginField *pRspUserLogin, CQdFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///û˳Ӧ
	virtual void OnRspUserLogout(CQdFtdcRspUserLogoutField *pRspUserLogout, CQdFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///֪ͨ
	virtual void OnRtnDepthMarketData(CQdFtdcDepthMarketDataField *pDepthMarketData) {};

	///֪ͨ
	virtual void OnRtnMultiDepthMarketData(CQdFtdcDepthMarketDataField *pDepthMarketData) {};

	///ĺԼϢ
	virtual void OnRspSubMarketData(CQdFtdcSpecificInstrumentField *pSpecificInstrument, CQdFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///˶ԼϢ
	virtual void OnRspUnSubMarketData(CQdFtdcSpecificInstrumentField *pSpecificInstrument, CQdFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ּ
	virtual void OnRtnMBLMarketData(CQdFtdcMBLMarketDataField *pMBLMarketData) {};

	///֣ݺԼ״̬
	virtual void OnRtnQmdInstrumentStatu(CQdFtdcQmdInstrumentStateField *pQmdInstrumentState) {};

	///Ӧ
	virtual void OnRspSubscribeTopic(CQdFtdcDisseminationField *pDissemination, CQdFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ѯӦ
	virtual void OnRspQryTopic(CQdFtdcDisseminationField *pDissemination, CQdFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ԼӦ
	virtual void OnRspQryMarketData(CQdFtdcRspMarketDataField *pRspMarketData, CQdFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///гԼѯӦ
	virtual void OnRspQryTopicInstruments(CQdFtdcSpecificInstrumentField *pSpecificInstrument, CQdFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///гԼбѯӦ
	virtual void OnRspQryInstrumentList(CQdFtdcSpecificInstrumentField *pSpecificInstrument, CQdFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///DCELevel2֪ͨ
	virtual void OnRtnTenEntrust(CQdFtdcMDTenDepthMarketDataField *pMDTenDepthMarketData) {};

	///Ȩ֪ͨ
	virtual void OnRtnOptionIndexData(CQdFtdcOptionIndexDataField *pOptionIndexData) {};
};

class MDUSER_API_EXPORT CQdFtdcMduserApi
{
public:
	///MduserApi
	///@param pszFlowPath ϢļĿ¼ĬΪǰĿ¼
	///@return UserApi
	static CQdFtdcMduserApi *CreateFtdcMduserApi(const char *pszFlowPath = "");
	
	///ȡϵͳ汾
	///@param nMajorVersion 汾
	///@param nMinorVersion Ӱ汾
	///@return ϵͳʶַ
	static const char *GetVersion();
	
	///ɾӿڶ
	///@remark ʹñӿڶʱ,øúɾӿڶ
	virtual void Release() = 0;
	
	//ಥÿ
	virtual void SetMultiCast(bool bMultiCast=false) = 0;

	//עಥַ
	virtual void RegTopicMultiAddr(char *pMultiAddr)=0;
	
	
	///ʼ
	///@remark ʼл,ֻеú,ӿڲſʼ
	virtual void Init() = 0;
	
	///ȴӿ߳̽
	///@return ߳˳
	virtual int Join() = 0;
	
	///ȡǰ
	///@retrun ȡĽ
	///@remark ֻе¼ɹ,ܵõȷĽ
	virtual const char *GetTradingDay() = 0;
	
	///עǰûַ
	///@param pszFrontAddressǰûַ
	///@remark ַĸʽΪprotocol://ipaddress:port磺tcp://127.0.0.1:17001 
	///@remark tcpЭ飬127.0.0.1ַ17001˿ںš
	virtual void RegisterFront(char *pszFrontAddress) = 0;
	
	///עַַ
	///@param pszNsAddressַַ
	///@remark ַĸʽΪprotocol://ipaddress:port磺tcp://127.0.0.1:12001 
	///@remark tcpЭ飬127.0.0.1ַ12001˿ںš
	///@remark RegisterFrontRegisterNameServer
	virtual void RegisterNameServer(char *pszNsAddress) = 0;
	
	///עصӿ
	///@param pSpi Իصӿʵ
	virtual void RegisterSpi(CQdFtdcMduserSpi *pSpi) = 0;

	///г顣
	///@param nTopicID г  
	///@param nResumeType гشʽ  
	///        QD_TERT_RESTART:ӱտʼش
	///        QD_TERT_RESUME:ϴյ(ǶȫԼʱ֧ģʽ)
	///        QD_TERT_QUICK:ȴ͵ǰ,ٴ͵¼г
	///@remark ÷ҪInitǰá򲻻յ˽ݡ
	virtual void SubscribeMarketDataTopic(int nTopicID, QD_TE_RESUME_TYPE nResumeType) = 0;

	///ĺԼ顣
	///@param ppInstrumentID ԼID  
	///@param nCount Ҫ/˶ĺԼ
	///@remark 
	virtual int SubMarketData(char *ppInstrumentID[], int nCount)=0;

	///˶Լ顣
	///@param ppInstrumentID ԼID  
	///@param nCount Ҫ/˶ĺԼ
	///@remark 
	virtual int UnSubMarketData(char *ppInstrumentID[], int nCount)=0;		
	
	///ʱʱ䡣
	///@param timeout ʱʱ()  
	virtual void SetHeartbeatTimeout(unsigned int timeout) = 0;

	
	///ڴȡֵ
	///@param CQdFtdcShmDepthMarketDataField  
	///@param CQdFtdcDepthMarketDataField ѯֵ
	///@return 0 ɹ
	///@return -1 ־ļʧ
	virtual void ShmMarketData(CQdFtdcShmDepthMarketDataField *reqfield,CQdFtdcDepthMarketDataField *defdata) = 0;
	
    ///UDP
	///@param  udpip㲥ַ
	///@return 0 ɹ
	///@return -1 ȡUDPʧ
	virtual  void setudpchannel(char *udpip)= 0;

	///û¼
	virtual int ReqUserLogin(CQdFtdcReqUserLoginField *pReqUserLogin, int nRequestID) = 0;

	///û˳
	virtual int ReqUserLogout(CQdFtdcReqUserLogoutField *pReqUserLogout, int nRequestID) = 0;

	///ĺԼϢ
	virtual int ReqSubMarketData(CQdFtdcSpecificInstrumentField *pSpecificInstrument, int nRequestID) = 0;

	///˶ԼϢ
	virtual int ReqUnSubMarketData(CQdFtdcSpecificInstrumentField *pSpecificInstrument, int nRequestID) = 0;

	///
	virtual int ReqSubscribeTopic(CQdFtdcDisseminationField *pDissemination, int nRequestID) = 0;

	///ѯ
	virtual int ReqQryTopic(CQdFtdcDisseminationField *pDissemination, int nRequestID) = 0;

	///Լѯ
	virtual int ReqQryMarketData(CQdFtdcQryMarketDataField *pQryMarketData, int nRequestID) = 0;

	///гԼѯ
	virtual int ReqQryTopicInstruments(CQdFtdcMarketDataExchangeIDField *pMarketDataExchangeID, int nRequestID) = 0;

	///гԼбѯ
	virtual int ReqQryInstrumentList(CQdFtdcMarketDataExchangeIDField *pMarketDataExchangeID, int nRequestID) = 0;

	//ಥ
	//޷¼£ô˽ӿڿԽ鲥
	//ڿԵ¼ô˽ӿ
	//@param TradingDay գûе¼£ȻգҪע⽻Ľ
	virtual void ActiveMultiMarketData(char * TradingDay) = 0;
protected:
	~CQdFtdcMduserApi(){};
};

#endif
