#include "QdpFtdcTraderApi.h"
#include <iostream>
#include <cstdlib>
#include <string.h>
#include <stdio.h>
#include <thread>
#include <chrono>
#include <map>
#include <string>

using namespace std;

// ¼Ƿɵı־
// ͹˾
TQdpFtdcBrokerIDType g_chBrokerID;
// û
TQdpFtdcUserIDType g_chUserID;
// û
TQdpFtdcPasswordType g_chPassword;
// Ͷߴ
TQdpFtdcInvestorIDType g_chInvestorID;
// û󱨵
int g_nOrdLocalID = 0;
/* ֤Ϣ */
// ǷҪ֤ 0-Ҫ 1-Ҫ
int g_nAuthenticate = 0;
TQdpFtdcAppIDType g_chAppID;
TQdpFtdcPasswordType g_chAuthCode;

/// API
CQdpFtdcTraderApi *g_pTraderApi = NULL;
typedef map<string, int> CInstumentIDNumMap; // InstrumentID -> InstrumentIDNum
CInstumentIDNumMap g_mapInstrumentIDNum;

void ReqLogin(int RequestID);

void ReqAuth(int RequestID);

void ReqUserPasswordUpdate(int RequestID);

void ReqSubPrdTradeFlow(int RequestID);

void ReqUnSubPrdTradeFlow(int RequestID);

void ReqForQuoteInsert(int RequestID);

void ReqQryForQuote(int RequestID);

void ReqQryMarketData(int RequestID);

void ReqQryExchange(int &RequestID);

void ReqQryTrade(int &RequestID);

void ReqQryOrder(int &RequestID);

void ReqQuoteAction(int RequestID);

void ReqQuoteInsert(int RequestID);

void ReqSubmitUserSystemInfo(int RequestID);

int ReqSetClientMaxSigVol(int RequestID);

int ReqOrderAction(int RequestID);

int ReqOrderInsert(int RequestID);

int ReqQryUserInvestor(int RequestID);

int ReqQryInvestorAccount(int RequestID);

int ReqQryInvestorOptionFee(int RequestID);

int ReqQryInvestorMargin(int RequestID);

int ReqQryInstrument(int RequestID);

int ReqQrySGEDeferRate(int RequestID);

int ReqQryInvestorFee(int RequestID);

int ReqQryInvestorPosition(int RequestID);

class CTraderSpi : public CQdpFtdcTraderSpi
{
public:
    CTraderSpi(CQdpFtdcTraderApi *pUserApi) : m_pTraderApi(pUserApi),
                                              m_bIsLogin(false),
                                              m_bConnected(false)
    {
        g_mapInstrumentIDNum.clear();
    }
    ~CTraderSpi() {};

    // ʵCTraderSpiĸӿ
    virtual void OnFrontConnected()
    {
        std::cout << "OnFrontConnected\n";
        m_bConnected = true;
    };

    virtual void OnFrontDisconnected(int nReason)
    {
        std::cout << "OnFrontDisconnected: " << nReason << std::endl;
        m_bConnected = false;
        m_bIsLogin = false;
    }

    virtual void OnRspUserLogin(CQdpFtdcRspUserLoginField *pRspUserLogin, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast)
    {
        if (pRspInfo == NULL)
        {
            std::cout << "OnRspUserLogin=NULL!\n";
            return;
        }

        if (pRspInfo->ErrorID != 0)
        {
            std::cout << "UserID: " << g_chUserID << "Login failed, ErrorMsg: " << pRspInfo->ErrorMsg;
            return;
        }
        std::cout << "UserID: " << g_chUserID << "Login Success.\n";

        /// ׼ QDP_TERT_PRIVATE ˽; QDP_TERT_PUBLIC ;
        CQdpFtdcFlowStatusField ftdField1;
        memset(&ftdField1, 0, sizeof(CQdpFtdcFlowStatusField));
        ftdField1.SequenceSeries = QDP_TERT_PRIVATE;
        ftdField1.bReady = true;
        m_pTraderApi->ReqReady(&ftdField1, 0);
        memset(&ftdField1, 0, sizeof(CQdpFtdcFlowStatusField));
        ftdField1.SequenceSeries = QDP_TERT_PUBLIC;
        ftdField1.bReady = true;
        m_pTraderApi->ReqReady(&ftdField1, 0);

        m_bIsLogin = true;
    }

    virtual void OnRspUserLogout(CQdpFtdcRspUserLogoutField *pRspUserLogout, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast)
    {
        if (pRspInfo == NULL)
        {
            std::cout << "OnRspUserLogout=NULL!\n";
            return;
        }
        if (pRspInfo->ErrorID != 0)
        {
            std::cout << "OnRspUserLogout failed, ErrorMsg:" << pRspInfo->ErrorMsg << "\n";
            return;
        }

        m_bIsLogin = false;
    }

    virtual void OnRspUserPasswordUpdate(CQdpFtdcUserPasswordUpdateField *pUserPasswordUpdate, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast)
    {
        if (pRspInfo == NULL)
        {
            std::cout << "OnRspUserPasswordUpdate=NULL!\n";
            return;
        }
        if (pRspInfo->ErrorID != 0)
        {
            std::cout << "OnRspUserPasswordUpdate failed, ErrorMsg:" << pRspInfo->ErrorMsg << "\n";
            return;
        }
    }

    virtual void OnRspAuthenticate(CQdpFtdcRtnAuthenticateField *pRtnAuthenticate, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast)
    {
        if (pRspInfo == NULL)
        {
            std::cout << "OnRspAuthenticate=NULL!\n";
            return;
        }
        if (pRspInfo->ErrorID != 0)
        {
            std::cout << "OnRspAuthenticate failed, ErrorMsg:" << pRspInfo->ErrorMsg << "\n";
            return;
        }

        std::cout << "OnRspAuthenticate success, UserID:" << pRtnAuthenticate->UserID << "\n";

        // ֤ɹ¼
        ReqLogin(nRequestID);
    }

    // traderSPI
    virtual void OnRtnTrade(CQdpFtdcTradeField *pTrade)
    {
        std::cout << "OnRtnTrade: OrderSysID=" << pTrade->OrderSysID
                  << ", InstrumentID=" << pTrade->InstrumentID
                  << ", TradeID=" << pTrade->TradeID
                  << ", TradeVolume=" << pTrade->TradeVolume
                  << "\n";
    }

    virtual void OnRtnOrder(CQdpFtdcOrderField *pOrder)
    {
        // store OrderSysID
        std::cout << "OnRtnOrder: OrderSysID=" << pOrder->OrderSysID
                  << ", InstrumentID=" << pOrder->InstrumentID
                  << ", Volume=" << pOrder->Volume
                  << ", OrderStatus=" << pOrder->OrderStatus
                  << "\n";
    }

    virtual void OnRtnInstrumentStatus(CQdpFtdcInstrumentStatusField *pInstrumentStatus) {}

    // virtual void OnErrRtnOrderInsert(CQdpFtdcInputOrderField* pInputOrder, CQdpFtdcRspInfoField* pRspInfo){};

    virtual void OnRspOrderAction(CQdpFtdcOrderActionField *pOrderAction, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast)
    {
        if (pRspInfo == NULL)
        {
            std::cout << "OnRspOrderAction=NULL!\n";
            return;
        }
        if (pRspInfo != NULL && pRspInfo->ErrorID != 0)
        {
            std::cout << "OnRspOrderAction failed, ErrorMsg:" << pRspInfo->ErrorMsg << "\n";
            return;
        }
        std::cout << "OnRspOrderAction success, OrderSysID=" << pOrderAction->OrderSysID;
    }

    // QuerySPI
    virtual void OnRspQryUserInvestor(CQdpFtdcRspUserInvestorField *pRspUserInvestor, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast)
    {
        std::cout << "UserID:" << pRspUserInvestor->UserID
                  << "InvestorID:" << pRspUserInvestor->InvestorID << "\n";
    }

    // virtual void OnRspQryInvestor(CQdpFtdcRspQryInvestorField *pRspQryInvestor, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast){};

    virtual void OnRspQryInvestorPosition(CQdpFtdcRspInvestorPositionField *pRspInvestorPosition, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast)
    {
        std::cout << "OnRspQryInvestorPosition\n";
        if (pRspInfo != NULL && pRspInfo->ErrorID != 0)
        {
            std::cout << "failed; ErrorID: " << pRspInfo->ErrorID
                      << ", ErrorMsg: " << pRspInfo->ErrorMsg << ", RequestID: " << nRequestID << "\n";
            return;
        }

        if (pRspInvestorPosition != NULL)
        {
            // ֲֳܳɱ ֲܳ Լ
            std::cout << "Success; InvestorID=[" << pRspInvestorPosition->InvestorID
                      << "], InstrumentID=[" << pRspInvestorPosition->InstrumentID
                      << "], UsedMargin=[" << pRspInvestorPosition->UsedMargin
                      << "], FrozenMargin=[" << pRspInvestorPosition->FrozenMargin
                      << "], FrozenPremium=[" << pRspInvestorPosition->FrozenPremium
                      << "], PositionProfit=[" << pRspInvestorPosition->PositionProfit
                      << "], PositionCost=[" << pRspInvestorPosition->PositionCost
                      << "], TodayPosition=[" << pRspInvestorPosition->TodayPosition
                      << "];\n";
        }
    }

    virtual void OnRspQryInstrument(CQdpFtdcRspInstrumentField *pRspInstrument, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast)
    {
        std::cout << "OnRspQryInstrument\n";

        if (pRspInfo != NULL && pRspInfo->ErrorID != 0)
        {
            std::cout << "failed; ErrorID: " << pRspInfo->ErrorID
                      << ", ErrorMsg: " << pRspInfo->ErrorMsg << ", RequestID: " << nRequestID << "\n";
            return;
        }

        if (pRspInstrument != NULL)
        {
            g_mapInstrumentIDNum.insert(CInstumentIDNumMap::value_type(pRspInstrument->InstrumentID, pRspInstrument->InstrumentIDNum));
            std::cout << "Success; ExchangeID=[" << pRspInstrument->ExchangeID
                      << "], InstrumentID=[" << pRspInstrument->InstrumentID
                      << "], InstrumentIDNum=" << pRspInstrument->InstrumentIDNum // API7.0汾УʱдInstrumentIDNum
                      << "], VolumeMultiple=[" << pRspInstrument->VolumeMultiple
                      << "], PriceTick=[" << pRspInstrument->PriceTick
                      << "], PreSettlementPrice=[" << pRspInstrument->PreSettlementPrice
                      << "], InstrumentStatus=[" << pRspInstrument->InstrumentStatus
                      << "];\n";
        }
    }

    virtual void OnRspQryInvestorAccount(CQdpFtdcRspInvestorAccountField *pRspInvestorAccount, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast)
    {
        std::cout << "OnRspQryInvestorAccount\n";

        if (pRspInfo != NULL && pRspInfo->ErrorID != 0)
        {
            std::cout << "failed; ErrorID: " << pRspInfo->ErrorID
                      << ", ErrorMsg: " << pRspInfo->ErrorMsg << ", RequestID: " << nRequestID << "\n";
            return;
        }

        if (pRspInvestorAccount != NULL)
        {
            std::cout << "Success; AccountID=[" << pRspInvestorAccount->AccountID
                      << "InvestorID=[" << pRspInvestorAccount->InvestorID
                      << "], PreBalance=[" << pRspInvestorAccount->PreBalance
                      << "], PreAvailable=[" << pRspInvestorAccount->PreAvailable
                      << "], CloseProfit=[" << pRspInvestorAccount->CloseProfit
                      << "], PositionProfit=[" << pRspInvestorAccount->PositionProfit
                      << "], Fee=[" << pRspInvestorAccount->Fee
                      << "], FrozenFee=[" << pRspInvestorAccount->FrozenFee
                      << "], FrozenPremium=[" << pRspInvestorAccount->FrozenPremium
                      << "], Margin=[" << pRspInvestorAccount->Margin
                      << "], FrozenMargin=[" << pRspInvestorAccount->FrozenMargin
                      << "], Available=[" << pRspInvestorAccount->Available
                      << "], DynamicRights=[" << pRspInvestorAccount->DynamicRights
                      << "], Balance=[" << pRspInvestorAccount->Balance
                      << "], Deposit=[" << pRspInvestorAccount->Deposit
                      << "], Withdraw=[" << pRspInvestorAccount->Withdraw
                      << "];\n";
        }
    }

    virtual void OnRspQryInvestorMargin(CQdpFtdcInvestorMarginField *pInvestorMargin, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast)
    {
        std::cout << "OnRspQryInvestorMargin\n";
        if (pRspInfo != NULL && pRspInfo->ErrorID != 0)
        {
            std::cout << "failed; ErrorID: " << pRspInfo->ErrorID
                      << ", ErrorMsg: " << pRspInfo->ErrorMsg << ", RequestID: " << nRequestID << "\n";
            return;
        }
        if (pInvestorMargin != NULL)
        {
            std::cout << "Success; InstrumentID=[" << pInvestorMargin->InstrumentID
                      << "], InvestorID=[" << pInvestorMargin->InvestorID
                      << "], HedgeFlag=[" << pInvestorMargin->HedgeFlag
                      << "], LongMarginRate=[" << pInvestorMargin->LongMarginRate
                      << "], LongMarginAmt=[" << pInvestorMargin->LongMarginAmt
                      << "], ShortMarginRate=[" << pInvestorMargin->ShortMarginRate
                      << "], ShortMarginAmt=[" << pInvestorMargin->ShortMarginAmt
                      << "];" << "\n";
        }
    }

    virtual void OnRspQryInvestorFee(CQdpFtdcInvestorFeeField *pInvestorFee, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast)
    {
        std::cout << "OnRspQryInvestorFee\n";

        if (pRspInfo != NULL && pRspInfo->ErrorID != 0)
        {
            std::cout << "failed; ErrorID: " << pRspInfo->ErrorID
                      << ", ErrorMsg: " << pRspInfo->ErrorMsg << ", RequestID: " << nRequestID << "\n";
            return;
        }

        if (pInvestorFee != NULL)
        {
            std::cout << "Success; InstrumentID=[" << pInvestorFee->InstrumentID
                      << "], InvestorID=[" << pInvestorFee->InvestorID
                      << "], HedgeFlag=[" << pInvestorFee->HedgeFlag
                      << "], OpenFeeRate=[" << pInvestorFee->OpenFeeRate
                      << "], OpenFeeAmt=[" << pInvestorFee->OpenFeeAmt
                      << "], OffsetFeeRate=[" << pInvestorFee->OffsetFeeRate
                      << "], OffsetFeeAmt=[" << pInvestorFee->OffsetFeeAmt
                      << "], OTFeeRate=[" << pInvestorFee->OTFeeRate
                      << "], OTFeeAmt=[" << pInvestorFee->OTFeeAmt
                      << "];" << "\n";
        }
    }

    virtual void OnRspQryInvestorOptionFee(CQdpFtdcRspInvestorOptionFeeField *pRspInvestorOptionFee, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast)
    {
        std::cout << "OnRspQryInvestorOptionFee\n";

        if (pRspInfo != NULL && pRspInfo->ErrorID != 0)
        {
            std::cout << "failed; ErrorID: " << pRspInfo->ErrorID
                      << ", ErrorMsg: " << pRspInfo->ErrorMsg << ", RequestID: " << nRequestID << "\n";
            return;
        }

        if (pRspInvestorOptionFee != NULL)
        {
            std::cout << "Success; InstrumentID=[" << pRspInvestorOptionFee->InstrumentID
                      << "], InvestorID=[" << pRspInvestorOptionFee->InvestorID
                      << "], OpenFeeRate=[" << pRspInvestorOptionFee->OpenFeeRate
                      << "], OpenFeeAmt=[" << pRspInvestorOptionFee->OpenFeeAmt
                      << "], OffsetFeeRate=[" << pRspInvestorOptionFee->OffsetFeeRate
                      << "], OffsetFeeAmt=[" << pRspInvestorOptionFee->OffsetFeeAmt
                      << "], OTFeeRate=[" << pRspInvestorOptionFee->OTFeeRate
                      << "], OTFeeAmt=[" << pRspInvestorOptionFee->OTFeeAmt
                      << "], StrikeFeeRate=[" << pRspInvestorOptionFee->StrikeFeeRate
                      << "], StrikeFeeAmt=[" << pRspInvestorOptionFee->StrikeFeeAmt
                      << "];" << "\n";
        }
    }

    virtual void OnRspQryMarketData(CQdpFtdcMarketDataField *pMarketData, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast)
    {
        std::cout << "OnRspQryMarketData\n";
        if (pRspInfo != NULL && pRspInfo->ErrorID != 0)
        {
            std::cout << "failed; ErrorID: " << pRspInfo->ErrorID
                      << ", ErrorMsg: " << pRspInfo->ErrorMsg << ", RequestID: " << nRequestID << "\n";
            return;
        }

        if (pMarketData != NULL)
        {
            std::cout << "Success; InstrumentID=[" << pMarketData->InstrumentID
                      << "], ExchangeID=[" << pMarketData->ExchangeID
                      << "], LastPrice=[" << pMarketData->LastPrice
                      << "], PreSettlementPrice=[" << pMarketData->PreSettlementPrice
                      << "], OpenPrice=[" << pMarketData->OpenPrice
                      << "], HighestPrice=[" << pMarketData->HighestPrice
                      << "], LowestPrice=[" << pMarketData->LowestPrice
                      << "], Volume=[" << pMarketData->Volume
                      << "], Turnover=[" << pMarketData->Turnover
                      << "], OpenInterest=[" << pMarketData->OpenInterest
                      << "], PreClosePrice=[" << pMarketData->PreClosePrice
                      << "], SettlementPrice=[" << pMarketData->SettlementPrice
                      << "], UpperLimitPrice=[" << pMarketData->UpperLimitPrice
                      << "], LowerLimitPrice=[" << pMarketData->LowerLimitPrice
                      << "];" << "\n";
        }
    }

    virtual void OnRspQryExchange(CQdpFtdcRspExchangeField *pRspExchange, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast)
    {
        std::cout << "OnRspQryExchange\n";
        if (pRspInfo != NULL && pRspInfo->ErrorID != 0)
        {
            std::cout << "failed; ErrorID: " << pRspInfo->ErrorID
                      << ", ErrorMsg: " << pRspInfo->ErrorMsg << ", RequestID: " << nRequestID << "\n";
            return;
        }

        if (pRspExchange != NULL)
        {
            std::cout << "Success; ExchangeID=[" << pRspExchange->ExchangeID
                      << "], ExchangeName=[" << pRspExchange->ExchangeName
                      << "];" << "\n";
        }
    }

    virtual void OnRspQryTrade(CQdpFtdcTradeField *pTrade, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast)
    {
        std::cout << "OnRspQryTrade\n";
        if (pRspInfo != NULL && pRspInfo->ErrorID != 0)
        {
            std::cout << "failed; ErrorID: " << pRspInfo->ErrorID
                      << ", ErrorMsg: " << pRspInfo->ErrorMsg << ", RequestID: " << nRequestID << "\n";
            return;
        }

        if (pTrade != NULL)
        {
            std::cout << "Success; InstrumentID=[" << pTrade->InstrumentID
                      << "], InvestorID=[" << pTrade->InvestorID
                      << "], OrderSysID=[" << pTrade->OrderSysID
                      << "], ExchangeID=[" << pTrade->ExchangeID
                      << "], TradeID=[" << pTrade->TradeID
                      << "], TradeVolume=[" << pTrade->TradeVolume
                      << "], TradePrice=[" << pTrade->TradePrice
                      << "], TradeTime=[" << pTrade->TradeTime
                      << "];" << "\n";
        }
    }

    virtual void OnRspQryOrder(CQdpFtdcOrderField *pOrder, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast)
    {
        std::cout << "OnRspQryOrder\n";
        if (pRspInfo != NULL && pRspInfo->ErrorID != 0)
        {
            std::cout << "failed; ErrorID: " << pRspInfo->ErrorID
                      << ", ErrorMsg: " << pRspInfo->ErrorMsg
                      << ", RequestID: " << nRequestID << std::endl;
            return;
        }

        if (pOrder != NULL)
        {
            std::cout << "Success; InstrumentID=[" << pOrder->InstrumentID
                      << "], InvestorID=[" << pOrder->InvestorID
                      << "], OrderSysID=[" << pOrder->OrderSysID
                      << "], ExchangeID=[" << pOrder->ExchangeID
                      << "], OrderStatus=[" << pOrder->OrderStatus
                      << "], Volume=[" << pOrder->Volume
                      << "], LimitPrice=[" << pOrder->LimitPrice
                      << "], VolumeTraded=[" << pOrder->VolumeTraded
                      << "], VolumeRemain=[" << pOrder->VolumeRemain
                      << "];" << "\n";
        }
    }

    virtual void OnRspQuoteAction(CQdpFtdcQuoteActionField *pQuoteAction, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast)
    {
        std::cout << "OnRspQuoteAction\n";
        if (pRspInfo != NULL && pRspInfo->ErrorID != 0)
        {
            std::cout << "failed; ErrorID: " << pRspInfo->ErrorID
                      << ", ErrorMsg: " << pRspInfo->ErrorMsg
                      << ", RequestID: " << nRequestID << std::endl;
            return;
        }
        if (pQuoteAction != NULL)
        {

            std::cout << "Success; UserOrderLocalID=[" << pQuoteAction->UserOrderLocalID
                      << "], UserOrderActionLocalID=[" << pQuoteAction->UserOrderActionLocalID
                      << "], OrderSysID=[" << pQuoteAction->OrderSysID
                      << "];\n";
        }
    }

    virtual void OnRtnQuote(CQdpFtdcQuoteField *pQuote)
    {
        // ۻر
        std::cout << "OnRtnQuote, OrderSysID=" << pQuote->OrderSysID
                  << ", InvestorID=" << pQuote->InvestorID
                  << ", UserOrderLocalID=" << pQuote->UserOrderLocalID
                  << ", OrderStatus=" << pQuote->OrderStatus
                  << ", BidOrderSysID=" << pQuote->BidOrderSysID
                  << ", AskOrderSysID=" << pQuote->AskOrderSysID
                  << "\n";
    }

    virtual void OnRspOrderInsert(CQdpFtdcRspInputOrderField *pRspInputOrder, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast)
    {
        std::cout << "OnRspOrderInsert\n";
        if (pRspInfo != NULL && pRspInfo->ErrorID != 0)
        {
            std::cout << "failed; ErrorID: " << pRspInfo->ErrorID
                      << ", ErrorMsg: " << pRspInfo->ErrorMsg
                      << ", RequestID: " << nRequestID << std::endl;
            return;
        }

        if (pRspInputOrder != NULL)
        {
            std::cout << "Success; InvestorIDNum=[" << pRspInputOrder->InvestorIDNum
                      << "],InstrumentID=[" << pRspInputOrder->InstrumentID
                      << "],OrderSysID=[" << pRspInputOrder->OrderSysID
                      << "],Volume=[" << pRspInputOrder->Volume
                      << "],LimitPrice=[" << pRspInputOrder->LimitPrice
                      << "],UserOrderLocalID=[" << pRspInputOrder->UserOrderLocalID
                      << "];\n";
        }
    }

    virtual void OnRspQryForQuote(CQdpFtdcForQuoteField *pForQuote, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast)
    {
        std::cout << "OnRspQryForQuote\n";
        if (pRspInfo != NULL && pRspInfo->ErrorID != 0)
        {
            std::cout << "failed; ErrorID: " << pRspInfo->ErrorID
                      << ", ErrorMsg: " << pRspInfo->ErrorMsg
                      << ", RequestID: " << nRequestID << std::endl;
            return;
        }

        if (pForQuote != NULL)
        {
            std::cout << "Success; InstrumentID=[" << pForQuote->InstrumentID
                      << "], ExchangeID=[" << pForQuote->ExchangeID
                      << "], InvestorID=[" << pForQuote->InvestorID
                      << "], ForQuoteStatus=[" << pForQuote->ForQuoteStatus
                      << "], UserOrderLocalID=[" << pForQuote->UserOrderLocalID
                      << "];\n";
        }
    }

    virtual void OnRspForQuoteInsert(CQdpFtdcInputForQuoteField *pInputForQuote, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast)
    {
        std::cout << "OnRspForQuoteInsert\n";
        if (pRspInfo != NULL && pRspInfo->ErrorID != 0)
        {
            std::cout << "failed; ErrorID: " << pRspInfo->ErrorID
                      << ", ErrorMsg: " << pRspInfo->ErrorMsg
                      << ", RequestID: " << nRequestID << std::endl;
            return;
        }

        if (pInputForQuote != NULL)
        {
            std::cout << "Success; InstrumentID=[" << pInputForQuote->InstrumentID
                      << "], ExchangeID=[" << pInputForQuote->ExchangeID
                      << "], InvestorID=[" << pInputForQuote->InvestorID
                      << "], UserOrderLocalID=[" << pInputForQuote->UserOrderLocalID
                      << "];\n";
        }
    }

    virtual void OnRspQuoteInsert(CQdpFtdcRspInputQuoteField *pRspInputQuote, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast)
    {
        std::cout << "OnRspQuoteInsert\n";
        if (pRspInfo != NULL && pRspInfo->ErrorID != 0)
        {
            std::cout << "failed; ErrorID: " << pRspInfo->ErrorID
                      << ", ErrorMsg: " << pRspInfo->ErrorMsg
                      << ", RequestID: " << nRequestID << std::endl;
            return;
        }

        if (pRspInputQuote != NULL)
        {
            std::cout << "Success; InstrumentIDNum=[" << pRspInputQuote->InstrumentIDNum
                      << "],InvestorIDNum=[" << pRspInputQuote->InvestorIDNum
                      << "],AskPrice=[" << pRspInputQuote->AskPrice
                      << "],AskVolume=[" << pRspInputQuote->AskVolume
                      << "],BidPrice=[" << pRspInputQuote->BidPrice
                      << "],BidVolume=[" << pRspInputQuote->BidVolume
                      << "],BidOrderRef=[" << pRspInputQuote->BidOrderRef
                      << "],AskOrderRef=[" << pRspInputQuote->AskOrderRef
                      << "],ExchangeID=[" << pRspInputQuote->ExchangeID
                      << "],OrderSysID=[" << pRspInputQuote->OrderSysID
                      << "\n";
        }
    }

private:
    CQdpFtdcTraderApi *m_pTraderApi;

public:
    bool m_bIsLogin;
    bool m_bConnected;
};

int GetInstrumentIDNum(const char *pInstrumentID)
{
    CInstumentIDNumMap::iterator it = g_mapInstrumentIDNum.find(string(pInstrumentID));
    if (it != g_mapInstrumentIDNum.end())
    {
        return it->second;
    }
    else
    {
        return 0;
    }
}

void ReqLogin(int RequestID)
{
    CQdpFtdcReqUserLoginField reqUserLogin;

    strcpy(reqUserLogin.UserProductInfo, "demo_test");
    strcpy(reqUserLogin.BrokerID, g_chBrokerID);
    strcpy(reqUserLogin.UserID, g_chUserID);
    strcpy(reqUserLogin.Password, g_chPassword);
    // ½
    g_pTraderApi->ReqUserLogin(&reqUserLogin, RequestID);
}

void ReqAuth(int RequestID)
{
    CQdpFtdcAuthenticateField reqfield;
    strcpy(reqfield.BrokerID, g_chBrokerID);
    strcpy(reqfield.UserID, g_chUserID);
    strcpy(reqfield.UserProductInfo, "demo_test");
    strcpy(reqfield.AppID, g_chAppID);
    strcpy(reqfield.AuthCode, g_chAuthCode);
    // ֤
    g_pTraderApi->ReqAuthenticate(&reqfield, RequestID);
}

void ReqUserPasswordUpdate(int RequestID)
{
    std::cout << "ReqUserPasswordUpdate Info:" << std::endl;
    CQdpFtdcUserPasswordUpdateField t_field;
    memset(&t_field, 0, sizeof(t_field));
    strcpy(t_field.BrokerID, g_chBrokerID);
    strcpy(t_field.UserID, g_chUserID);
    std::cout << "OldPassword: ";
    std::cin >> t_field.OldPassword;
    std::cout << "NewPassword: ";
    std::cin >> t_field.NewPassword;
    g_pTraderApi->ReqUserPasswordUpdate(&t_field, RequestID);
}

void ReqSubPrdTradeFlow(int RequestID)
{
    std::cout << "ReqSubPrdTradeFlow Info:" << std::endl;
    CQdpFtdcSpecificInstrumentField t_field;
    memset(&t_field, 0, sizeof(t_field));
    std::cout << "ProductID: ";
    std::cin >> t_field.InstrumentID;
    g_pTraderApi->ReqSubPrdTradeFlow(&t_field, RequestID);
}

void ReqUnSubPrdTradeFlow(int RequestID)
{
    std::cout << "ReqSubPrdTradeFlow Info:" << std::endl;
    CQdpFtdcSpecificInstrumentField t_field;
    memset(&t_field, 0, sizeof(t_field));
    std::cout << "ProductID: ";
    std::cin >> t_field.InstrumentID;
    g_pTraderApi->ReqUnSubPrdTradeFlow(&t_field, RequestID);
}

void ReqForQuoteInsert(int RequestID)
{
    std::cout << "ReqForQuoteInsert Info:" << std::endl;
    CQdpFtdcInputForQuoteField a_field;
    memset(&a_field, 0, sizeof(a_field));
    strcpy(a_field.BrokerID, g_chBrokerID);
    strcpy(a_field.InvestorID, g_chInvestorID);
    strcpy(a_field.UserID, g_chUserID);
    std::cout << "ExchangeID:";
    std::cin >> a_field.ExchangeID;
    std::cout << "InstrumentID: ";
    std::cin >> a_field.InstrumentID;
    a_field.UserOrderLocalID = ++g_nOrdLocalID;
    g_pTraderApi->ReqForQuoteInsert(&a_field, RequestID);
}

void ReqQryForQuote(int RequestID)
{
    std::cout << "ReqQryForQuote Info:" << std::endl;
    CQdpFtdcQryForQuoteField a_field;
    memset(&a_field, 0, sizeof(a_field));
    strcpy(a_field.BrokerID, g_chBrokerID);
    strcpy(a_field.InvestorID, g_chInvestorID);
    std::cout << "ExchangeID:";
    std::cin >> a_field.ExchangeID;
    std::cout << "InstrumentID: ";
    std::cin >> a_field.InstrumentID;
    g_pTraderApi->ReqQryForQuote(&a_field, RequestID);
}

void ReqQryMarketData(int RequestID)
{
    CQdpFtdcQryMarketDataField d_field;
    memset(&d_field, 0, sizeof(CQdpFtdcQryMarketDataField));
    g_pTraderApi->ReqQryMarketData(&d_field, RequestID);
}

void ReqQryExchange(int &RequestID)
{
    CQdpFtdcQryExchangeField t_field;
    memset(&t_field, 0, sizeof(CQdpFtdcQryExchangeField));
    g_pTraderApi->ReqQryExchange(&t_field, RequestID);
}

void ReqQryTrade(int &RequestID)
{
    CQdpFtdcQryTradeField t_field;
    memset(&t_field, 0, sizeof(CQdpFtdcQryTradeField));
    strcpy(t_field.BrokerID, g_chBrokerID);
    strcpy(t_field.UserID, g_chUserID);
    strcpy(t_field.InvestorID, g_chInvestorID);
    g_pTraderApi->ReqQryTrade(&t_field, RequestID);
}

void ReqQryOrder(int &RequestID)
{
    CQdpFtdcQryOrderField o_field;
    memset(&o_field, 0, sizeof(CQdpFtdcQryOrderField));
    strcpy(o_field.BrokerID, g_chBrokerID);
    strcpy(o_field.UserID, g_chUserID);
    strcpy(o_field.InvestorID, g_chInvestorID);
    g_pTraderApi->ReqQryOrder(&o_field, RequestID);
}

void ReqQuoteAction(int RequestID)
{
    std::cout << "ReqQuoteAction Info:" << std::endl;
    CQdpFtdcQuoteActionField quote;
    memset(&quote, 0, sizeof(quote));
    std::cout << "ExchangeID:";
    std::cin >> quote.ExchangeID;
    quote.UserOrderActionLocalID = ++g_nOrdLocalID;
    std::cout << "OrderSysID:";
    std::cin >> quote.OrderSysID;
    std::cout << "UserOrderLocalID:";
    std::cin >> quote.UserOrderLocalID;
    quote.ActionFlag = QDP_FTDC_AF_Delete;
    g_pTraderApi->ReqQuoteAction(&quote, RequestID);
}

void ReqQuoteInsert(int RequestID)
{
    std::cout << "ReqQuoteInsert Info:" << std::endl;
    CQdpFtdcInputQuoteField quote;
    memset(&quote, 0, sizeof(quote));
    // Լ -- ҪúԼѯ ȡԼӦĺԼ
    std::cout << "InstrumentID: ";
    string strInsturmentID = "";
    std::cin >> strInsturmentID;
    quote.InstrumentIDNum = GetInstrumentIDNum(strInsturmentID.c_str());
    std::cout << "InstrumentIDNum: " << quote.InstrumentIDNum;
    // ر
    quote.UserOrderLocalID = ++g_nOrdLocalID;
    // ͶIDNum
    quote.InvestorIDNum = atoi(g_chInvestorID);

    // 
    std::cout << "AskOffsetFlag: ";
    std::cin >> quote.AskOffsetFlag;
    std::cout << "AskHedgeFlag: ";
    std::cin >> quote.AskHedgeFlag;
    std::cout << "AskPrice: ";
    std::cin >> quote.AskPrice;
    std::cout << "AskVolume: ";
    std::cin >> quote.AskVolume;
    quote.AskOrderRef = ++g_nOrdLocalID;

    // 
    std::cout << "BidOffsetFlag: ";
    std::cin >> quote.BidOffsetFlag;
    std::cout << "BidHedgeFlag: ";
    std::cin >> quote.BidHedgeFlag;
    std::cout << "BidPrice: ";
    std::cin >> quote.BidPrice;
    std::cout << "BidVolume: ";
    std::cin >> quote.BidVolume;
    quote.BidOrderRef = ++g_nOrdLocalID;

    g_pTraderApi->ReqQuoteInsert(&quote, RequestID);
}

void ReqSubmitUserSystemInfo(int RequestID)
{
    CQdpFtdcUserSystemInfoField a_field;
    memset(&a_field, 0, sizeof(a_field));
    // ռĿ(qdpdatacollectapi)ȡϢд
    g_pTraderApi->ReqSubmitUserSystemInfo(&a_field, RequestID);
}

int ReqSetClientMaxSigVol(int RequestID)
{
    CQdpFtdcClientMaxSigVolField a_field;
    memset(&a_field, 0, sizeof(a_field));
    strcpy(a_field.BrokerID, g_chBrokerID);
    strcpy(a_field.ExchangeID, "CFFEX");
    strcpy(a_field.InvestorID, g_chInvestorID);
    a_field.HedgeFlag = '1';
    // strcpy(a_field.InstrumentID,"");
    // a_field.MaxSigVol = 10;
    return g_pTraderApi->ReqSetClientMaxSigVol(&a_field, RequestID);
}

int ReqOrderAction(int RequestID)
{
    std::cout << "ReqOrderAction Info:" << std::endl;
    CQdpFtdcOrderActionField ord;
    memset(&ord, 0, sizeof(ord));
    // 
    std::cout << "ExchangeID: ";
    std::cin >> ord.ExchangeID;
    // ıر
    std::cout << "UserOrderLocalID: ";
    std::cin >> ord.UserOrderLocalID;
    // γıر
    ord.UserOrderActionLocalID = ++g_nOrdLocalID;
    // 
    std::cout << "OrderSysID: ";
    std::cin >> ord.OrderSysID;
    // ־
    ord.ActionFlag = QDP_FTDC_AF_Delete;

    return g_pTraderApi->ReqOrderAction(&ord, RequestID);
}

int ReqOrderInsert(int RequestID)
{
    std::cout << "ReqOrderInsert Info:" << std::endl;
    CQdpFtdcInputOrderField ord;
    memset(&ord, 0, sizeof(ord));
    // Ͷ߱ (API7.0汾,InstrumentIDNumͨԼѯĻصȡ)
    ord.InvestorIDNum = atoi(g_chInvestorID);
    // Լ -- ҪúԼѯ ȡԼӦĺԼ
    std::cout << "InstrumentID: ";
    string strInsturmentID = "";
    std::cin >> strInsturmentID;
    ord.InstrumentIDNum = GetInstrumentIDNum(strInsturmentID.c_str());
    std::cout << "InstrumentIDNum: " << ord.InstrumentIDNum << std::endl;
    // ر
    ord.UserOrderLocalID = ++g_nOrdLocalID;
    // 
    std::cout << "OrderPriceType: ";
    std::cin >> ord.OrderPriceType;
    // ord.OrderPriceType = QDP_FTDC_OPT_LimitPrice;
    // 
    std::cout << "Direction: ";
    std::cin >> ord.Direction;
    // ord.Direction = QDP_FTDC_D_Buy;
    // ƽ־
    std::cout << "OffsetFlag: ";
    std::cin >> ord.OffsetFlag;
    // strcpy(&(ord.OffsetFlag), "0");
    // Ͷױ־
    std::cout << "HedgeFlag: ";
    std::cin >> ord.HedgeFlag;
    // strcpy(&(ord.HedgeFlag), "1");
    // ۸
    std::cout << "LimitPrice: ";
    std::cin >> ord.LimitPrice;
    // ord.LimitPrice = 3074;
    // 
    std::cout << "Volume: ";
    std::cin >> ord.Volume;
    // ord.Volume = 1;
    // Ч
    std::cout << "TimeCondition: ";
    std::cin >> ord.TimeCondition;
    // ord.TimeCondition = QDP_FTDC_TC_GFD;
    // ɽ
    std::cout << "VolumeCondition: ";
    std::cin >> ord.VolumeCondition;
    // ord.VolumeCondition = QDP_FTDC_VC_AV;

    return g_pTraderApi->ReqOrderInsert(&ord, RequestID);
}

int ReqQryUserInvestor(int RequestID)
{
    CQdpFtdcQryUserInvestorField a_field;
    memset(&a_field, 0, sizeof(CQdpFtdcQryUserInvestorField));
    strcpy(a_field.BrokerID, g_chBrokerID);
    strcpy(a_field.UserID, g_chUserID);
    return g_pTraderApi->ReqQryUserInvestor(&a_field, RequestID);
}

int ReqQryInvestorAccount(int RequestID)
{
    CQdpFtdcQryInvestorAccountField a_field;
    memset(&a_field, 0, sizeof(CQdpFtdcQryInvestorAccountField));
    strcpy(a_field.BrokerID, g_chBrokerID);
    strcpy(a_field.UserID, g_chUserID);
    strcpy(a_field.InvestorID, g_chInvestorID);
    return g_pTraderApi->ReqQryInvestorAccount(&a_field, RequestID);
}

int ReqQryInvestorOptionFee(int RequestID)
{
    CQdpFtdcQryInvestorOptionFeeField of_field;
    memset(&of_field, 0, sizeof(CQdpFtdcQryInvestorOptionFeeField));
    strcpy(of_field.BrokerID, g_chBrokerID);
    strcpy(of_field.UserID, g_chUserID);
    strcpy(of_field.InvestorID, g_chInvestorID);
    return g_pTraderApi->ReqQryInvestorOptionFee(&of_field, RequestID);
}

int ReqQryInvestorMargin(int RequestID)
{
    CQdpFtdcQryInvestorMarginField m_field;
    memset(&m_field, 0, sizeof(CQdpFtdcQryInvestorMarginField));
    strcpy(m_field.BrokerID, g_chBrokerID);
    strcpy(m_field.UserID, g_chUserID);
    strcpy(m_field.InvestorID, g_chInvestorID);
    return g_pTraderApi->ReqQryInvestorMargin(&m_field, RequestID);
}

int ReqQryInstrument(int RequestID)
{
    CQdpFtdcQryInstrumentField i_field;
    memset(&i_field, 0, sizeof(CQdpFtdcQryInstrumentField));
    return g_pTraderApi->ReqQryInstrument(&i_field, RequestID);
}

int ReqQrySGEDeferRate(int RequestID)
{
    CQdpFtdcQrySGEDeferRateField s_field;
    memset(&s_field, 0, sizeof(CQdpFtdcQrySGEDeferRateField));
    return g_pTraderApi->ReqQrySGEDeferRate(&s_field, RequestID);
}

int ReqQryInvestorFee(int RequestID)
{
    CQdpFtdcQryInvestorFeeField f_field;
    memset(&f_field, 0, sizeof(CQdpFtdcQryInvestorFeeField));
    strcpy(f_field.BrokerID, g_chBrokerID);
    strcpy(f_field.UserID, g_chUserID);
    return g_pTraderApi->ReqQryInvestorFee(&f_field, RequestID);
}

int ReqQryInvestorPosition(int RequestID)
{
    std::cout << "ReqQryInvestorPosition Info:" << std::endl;
    CQdpFtdcQryInvestorPositionField p_field;
    memset(&p_field, 0, sizeof(CQdpFtdcQryInvestorPositionField));
    strcpy(p_field.BrokerID, g_chBrokerID);
    strcpy(p_field.UserID, g_chUserID);
    strcpy(p_field.InvestorID, g_chInvestorID);
    std::cout << "ExchangeID: ";
    std::cin >> p_field.ExchangeID;
    std::cout << "InstrumentID: ";
    std::cin >> p_field.InstrumentID;
    return g_pTraderApi->ReqQryInvestorPosition(&p_field, RequestID);
}

void ShowHelp()
{
    std::cout << "ִжӦĲ:\n"
                 " 1: Լѯ(ִ, дInstrmentIDҲӦNum)\n"
                 " 2: ¼\n"
                 " 3: \n"
                 " 4: ͻϢֵ\n"
                 " 5: Ͷ˻ѯ\n"
                 " 6: Ͷʽ˻ѯ\n"
                 " 7: Ͷֲֲ߳ѯ\n"
                 " 8: Ͷʲѯ\n"
                 " 9: Ͷ֤߱ʲѯ\n"
                 "10: ӷʲѯ\n"
                 "11: ͶȨʲѯ\n"
                 "12: ¼\n"
                 "13: ۲\n"
                 "16: ѯ\n"
                 "17: ɽѯ\n"
                 "18: ѯ\n"
                 "19: ʵʱѯ\n"
                 "20: ѯ۲ѯ\n"
                 "21: ѯ¼\n"
                 "24: û޸\n"
                 "------------------------------\n";
}

void OrderFunc(CTraderSpi *pTraderSpi)
{
    if (NULL == pTraderSpi)
    {
        return;
    }
    while (!pTraderSpi->m_bConnected)
    {
        std::this_thread::sleep_for(std::chrono::microseconds(1000));
        continue;
    }
    int RequestID = 0;

    std::cout << "please input user info...\n";
    std::cout << "BrokerID:";
    std::cin >> g_chBrokerID;
    std::cout << "UserID:";
    std::cin >> g_chUserID;
    std::cout << "Password:";
    std::cin >> g_chPassword;
    std::cout << "InvestorID:";
    std::cin >> g_chInvestorID;
    // Ƿ֤ 0- 1-
    std::cout << "Is Need Authenticate (0-no, 1-yes):";
    std::cin >> g_nAuthenticate;
    if (g_nAuthenticate == 1)
    {
        std::cout << "AppID:";
        std::cin >> g_chAppID;
        std::cout << "AuthCode:";
        std::cin >> g_chAuthCode;
        ReqAuth(++RequestID);
    }
    else
    {
        ReqLogin(++RequestID);
    }

    while (!pTraderSpi->m_bIsLogin)
    {
        std::this_thread::sleep_for(std::chrono::microseconds(1000));
        continue;
    }

    // ע˱ص Ҫʱ
    // 
    int operationType = 0;
    while (1)
    {
        ShowHelp();
        // û ִжӦĲѯͱ
        std::cin >> operationType;
        switch (operationType)
        {
        case 1:
            // Լѯ
            ReqQryInstrument(RequestID);
            break;
        case 2:
            // ¼
            ReqOrderInsert(RequestID);
            break;
        case 3:
            // 
            ReqOrderAction(RequestID);
            break;
        case 4:
            // ͻϢֵ
            // ReqSetClientMaxSigVol(RequestID);
            break;
        case 5:
            // Ͷ˻ѯ
            ReqQryUserInvestor(RequestID);
            break;
        case 6:
            // Ͷʽ˻ѯ
            ReqQryInvestorAccount(RequestID);
            break;
        case 7:
            // Ͷֲֲ߳ѯ
            ReqQryInvestorPosition(RequestID);
            break;
        case 8:
            // Ͷʲѯ
            ReqQryInvestorFee(RequestID);
            break;
        case 9:
            // Ͷ֤߱ʲѯ
            ReqQryInvestorMargin(RequestID);
            break;
        case 10:
            // ӷʲѯ
            // ReqQrySGEDeferRate(RequestID);
            break;
        case 11:
            // ͶȨʲѯ
            ReqQryInvestorOptionFee(RequestID);
            break;
        case 12:
            // ¼
            ReqQuoteInsert(RequestID);
            break;
        case 13:
            // ۲
            ReqQuoteAction(RequestID);
            break;
        case 15:
            // ûɼϢ
            // ReqSubmitUserSystemInfo(RequestID);
            break;
        case 16:
            // ѯ
            ReqQryOrder(RequestID);
            break;
        case 17:
            // ɽѯ
            ReqQryTrade(RequestID);
            break;
        case 18:
            // ѯ
            ReqQryExchange(RequestID);
            break;
        case 19:
            // ʵʱѯ
            ReqQryMarketData(RequestID);
            break;
        case 20:
            // ѯ۲ѯ
            ReqQryForQuote(RequestID);
            break;
        case 21:
            // ѯ¼
            ReqForQuoteInsert(RequestID);
            break;
        case 22:
            // Ʒֽˮ
            // ReqSubPrdTradeFlow(RequestID);
            break;
        case 23:
            // ˶Ʒֽˮ
            // ReqUnSubPrdTradeFlow(RequestID);
            break;
        case 24:
            // û޸
            ReqUserPasswordUpdate(RequestID);
            break;
        default:
            break;
        }
        RequestID++;
    }
}

int main()
{
    // һCQdpFtdcTraderApiʵ
    CQdpFtdcTraderApi *pUserApi = CQdpFtdcTraderApi::CreateFtdcTraderApi();

    // api
    g_pTraderApi = pUserApi;

    // ȡAPI汾
    int max_version, min_version;
    std::cout << "API汾:" << CQdpFtdcTraderApi::GetVersion(max_version, min_version);

    // һ¼ʵ
    CTraderSpi *pTraderSpi = new CTraderSpi(pUserApi);

    // ע¼ʵ
    pUserApi->RegisterSpi(pTraderSpi);
    // ˽
    // QDP_TERT_RESTART:ӱտʼش
    // QDP_TERT_RESUME:ϴյ
    // QDP_TERT_QUICK:ֻ͵¼˽
    pUserApi->SubscribePrivateTopic(QDP_TERT_QUICK);
    // Ĺ
    // QDP_TERT_RESTART:ӱտʼش
    // QDP_TERT_RESUME:ϴյ
    // QDP_TERT_QUICK:ֻ͵¼˽
    pUserApi->SubscribePublicTopic(QDP_TERT_QUICK);

    // ͶƼĵַעַ
    //pUserApi->RegisterFront("tcp://192.168.92.212:30005");
    pUserApi->RegisterFront("tcp://140.206.192.11:60384");

    // ʱ
    // pUserApi->SetHeartbeatTimeout(240);

    // ʹͻ˿ʼ̨
    pUserApi->Init();

    OrderFunc(pTraderSpi);

    // ȴAPIʵ
    pUserApi->Join();
    // ͷAPIʵ
    pUserApi->Release();
    return 0;
}