/////////////////////////////////////////////////////////////////////////
///@system QuantDo Platform
///@company ϺͶƼ޹˾
///@file QdpFtdcTraderApi.h
///@brief ˿ͻ˽ӿ
///@history
///20150520	һ	ļ
/////////////////////////////////////////////////////////////////////////

#if !defined(QDP_FTDCTRADERAPI_H)
#define QDP_FTDCTRADERAPI_H

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "QdpFtdcUserApiStruct.h"

#if defined(ISLIB) && defined(WIN32)
#ifdef LIB_TRADER_API_EXPORT
#define TRADER_API_EXPORT __declspec(dllexport)
#else
#define TRADER_API_EXPORT __declspec(dllimport)
#endif
#else
#define TRADER_API_EXPORT 
#endif

class CQdpFtdcTraderSpi
{
public:
	///ͻ뽻׺̨ͨʱδ¼ǰ÷á
	virtual void OnFrontConnected(){};
	
	///ͻ뽻׺̨ͨӶϿʱ÷áAPIԶӣͻ˿ɲ
	///@param nReason ԭ
	///        0x1001 ʧ
	///        0x1002 дʧ
	///        0x2001 ʱ
	///        0x2002 ʧ
	///        0x2003 յ
	virtual void OnFrontDisconnected(int nReason){};
		
	///ʱ档ʱδյʱ÷á
	///@param nTimeLapse ϴνձĵʱ
	virtual void OnHeartBeatWarning(int nTimeLapse){};
	
	///Ļصʼ֪ͨAPIյһĺȵñȻǸĻصǱĻص֪ͨ
	///@param nTopicID 루˽ȣ
	///@param nSequenceNo 
	virtual void OnPackageStart(int nTopicID, int nSequenceNo){};
	
	///Ļص֪ͨAPIյһĺȵñĻصʼ֪ͨȻǸĻصñ
	///@param nTopicID 루˽ȣ
	///@param nSequenceNo 
	virtual void OnPackageEnd(int nTopicID, int nSequenceNo){};


	///Ӧ
	virtual void OnRspError(CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///û¼Ӧ
	virtual void OnRspUserLogin(CQdpFtdcRspUserLoginField *pRspUserLogin, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///û˳Ӧ
	virtual void OnRspUserLogout(CQdpFtdcRspUserLogoutField *pRspUserLogout, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///û޸Ӧ
	virtual void OnRspUserPasswordUpdate(CQdpFtdcUserPasswordUpdateField *pUserPasswordUpdate, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///¼Ӧ
	virtual void OnRspOrderInsert(CQdpFtdcRspInputOrderField *pRspInputOrder, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///Ӧ
	virtual void OnRspOrderAction(CQdpFtdcOrderActionField *pOrderAction, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ͻϢֵӦ
	virtual void OnRspSetClientMaxSigVol(CQdpFtdcClientMaxSigVolField *pClientMaxSigVol, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///֪ͨ
	virtual void OnRtnFlowMessageCancel(CQdpFtdcFlowMessageCancelField *pFlowMessageCancel) {};

	///ɽر
	virtual void OnRtnTrade(CQdpFtdcTradeField *pTrade) {};

	///ر
	virtual void OnRtnOrder(CQdpFtdcOrderField *pOrder) {};

	///¼ر
	virtual void OnErrRtnOrderInsert(CQdpFtdcRspInputOrderField *pRspInputOrder, CQdpFtdcRspInfoField *pRspInfo) {};

	///ر
	virtual void OnErrRtnOrderAction(CQdpFtdcOrderActionField *pOrderAction, CQdpFtdcRspInfoField *pRspInfo) {};

	///Լ״̬֪ͨ
	virtual void OnRtnInstrumentStatus(CQdpFtdcInstrumentStatusField *pInstrumentStatus) {};

	///˻ر
	virtual void OnRtnInvestorAccountDeposit(CQdpFtdcInvestorAccountDepositResField *pInvestorAccountDepositRes) {};

	///QDPϢ֪ͨ
	virtual void OnRtnMessageNotify(CQdpFtdcMessageNotifyInfoField *pMessageNotifyInfo) {};

	///ӷ֪ͨ
	virtual void OnRtnSGEDeferRate(CQdpFtdcSGEDeferRateField *pSGEDeferRate) {};

	///ѯӦ
	virtual void OnRspQryOrder(CQdpFtdcOrderField *pOrder, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ɽѯӦ
	virtual void OnRspQryTrade(CQdpFtdcTradeField *pTrade, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///Ͷ˻ѯӦ
	virtual void OnRspQryUserInvestor(CQdpFtdcRspUserInvestorField *pRspUserInvestor, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///Ͷʽ˻ѯӦ
	virtual void OnRspQryInvestorAccount(CQdpFtdcRspInvestorAccountField *pRspInvestorAccount, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ԼѯӦ
	virtual void OnRspQryInstrument(CQdpFtdcRspInstrumentField *pRspInstrument, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ѯӦ
	virtual void OnRspQryExchange(CQdpFtdcRspExchangeField *pRspExchange, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///Ͷֲֲ߳ѯӦ
	virtual void OnRspQryInvestorPosition(CQdpFtdcRspInvestorPositionField *pRspInvestorPosition, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///Ӧ
	virtual void OnRspSubscribeTopic(CQdpFtdcDisseminationField *pDissemination, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ѯӦ
	virtual void OnRspQryTopic(CQdpFtdcDisseminationField *pDissemination, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ͶʲѯӦ
	virtual void OnRspQryInvestorFee(CQdpFtdcInvestorFeeField *pInvestorFee, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///Ͷ֤߱ʲѯӦ
	virtual void OnRspQryInvestorMargin(CQdpFtdcInvestorMarginField *pInvestorMargin, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ӷʲѯӦ
	virtual void OnRspQrySGEDeferRate(CQdpFtdcSGEDeferRateField *pSGEDeferRate, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ͶȨʲѯӦ
	virtual void OnRspQryInvestorOptionFee(CQdpFtdcRspInvestorOptionFeeField *pRspInvestorOptionFee, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ʰͶֲ߳޶ѯӦ
	virtual void OnRspQryInvestorPositionLimit(CQdpFtdcRspInvestorPositionLimitField *pRspInvestorPositionLimit, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ʰ潻׻ʲѯӦ
	virtual void OnRspQryExchangeRate(CQdpFtdcRspExchangeRateField *pRspExchangeRate, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ʵʱѯӦ
	virtual void OnRspQryMarketData(CQdpFtdcMarketDataField *pMarketData, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ͨϢѯӦ
	virtual void OnRspQryFrontInfo(CQdpFtdcFrontInfoField *pFrontInfo, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ѯۻر
	virtual void OnRtnForQuote(CQdpFtdcForQuoteRspField *pForQuoteRsp) {};

	///ۻر
	virtual void OnRtnQuote(CQdpFtdcQuoteField *pQuote) {};

	///ѯ۲ѯӦ
	virtual void OnRspQryForQuote(CQdpFtdcForQuoteField *pForQuote, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ѯ¼Ӧ
	virtual void OnRspForQuoteInsert(CQdpFtdcInputForQuoteField *pInputForQuote, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///¼Ӧ
	virtual void OnRspQuoteInsert(CQdpFtdcRspInputQuoteField *pRspInputQuote, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///۲Ӧ
	virtual void OnRspQuoteAction(CQdpFtdcQuoteActionField *pQuoteAction, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///¼֤Ӧ
	virtual void OnRspAuthenticate(CQdpFtdcRtnAuthenticateField *pRtnAuthenticate, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///Ʒֽˮ
	virtual void OnRspSubPrdTradeFlow(CQdpFtdcSpecificInstrumentField *pSpecificInstrument, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///˶Ʒֽˮ
	virtual void OnRspUnSubPrdTradeFlow(CQdpFtdcSpecificInstrumentField *pSpecificInstrument, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};
};

class TRADER_API_EXPORT CQdpFtdcTraderApi
{
public:
	///TraderApi
	///@param pszFlowPath ϢļĿ¼ĬΪǰĿ¼
	///@return UserApi
	static CQdpFtdcTraderApi *CreateFtdcTraderApi(const char *pszFlowPath = "");
	
	///ȡϵͳ汾
	///@param nMajorVersion 汾
	///@param nMinorVersion Ӱ汾
	///@return ϵͳʶַ
	static const char *GetVersion(int &nMajorVersion, int &nMinorVersion);
	
	///ɾӿڶ
	///@remark ʹñӿڶʱ,øúɾӿڶ
	virtual void Release() = 0;
	
	///ʼ
	///@remark ʼл,ֻеú,ӿڲſʼ
	virtual void Init() = 0;
	
	///ȴӿ߳̽
	///@return ߳˳
	virtual int Join() = 0;
	
	///ȡǰ
	///@retrun ȡĽ
	///@remark ֻе¼ɹ,ܵõȷĽ
	virtual const char *GetTradingDay() = 0;
	
	///עǰûַ
	///@param pszFrontAddressǰûַ
	///@remark ַĸʽΪprotocol://ipaddress:port磺tcp://127.0.0.1:17001 
	///@remark tcpЭ飬127.0.0.1ַ17001˿ںš
	virtual void RegisterFront(char *pszFrontAddress) = 0;
	
	///עַַ
	///@param pszNsAddressַַ
	///@remark ַĸʽΪprotocol://ipaddress:port磺tcp://127.0.0.1:12001 
	///@remark tcpЭ飬127.0.0.1ַ12001˿ںš
	///@remark RegisterFrontRegisterNameServer
	virtual void RegisterNameServer(char *pszNsAddress) = 0;
	
	///עصӿ
	///@param pSpi Իصӿʵ
	virtual void RegisterSpi(CQdpFtdcTraderSpi *pSpi) = 0;
	

	///˽
	///@param nResumeType ˽شʽ  
	///        QDP_TERT_RESTART:ӱտʼش
	///        QDP_TERT_RESUME:ϴյ
	///        QDP_TERT_QUICK:ֻ͵¼˽
	///@remark ÷ҪInitǰá򲻻յ˽ݡ
	virtual void SubscribePrivateTopic(QDP_TE_RESUME_TYPE nResumeType) = 0;
	
	///Ĺ
	///@param nResumeType شʽ  
	///        QDP_TERT_RESTART:ӱտʼش
	///        QDP_TERT_RESUME:ϴյ
	///        QDP_TERT_QUICK:ֻ͵¼󹫹
	///@remark ÷ҪInitǰá򲻻յݡ
	virtual void SubscribePublicTopic(QDP_TE_RESUME_TYPE nResumeType) = 0;

	///ĽԱ
	///@param nResumeType Աشʽ  
	///        QDP_TERT_RESTART:ӱտʼش
	///        QDP_TERT_RESUME:ϴյ
	///        QDP_TERT_QUICK:ֻ͵¼Ա
	///@remark ÷ҪInitǰá򲻻յԱݡ
	virtual void SubscribeUserTopic(QDP_TE_RESUME_TYPE nResumeType) = 0;
	
	///ʱʱ䡣
	///@param timeout ʱʱ()  
	virtual void SetHeartbeatTimeout(unsigned int timeout) = 0;
	
	///־ļ
	///@param pszReqLogFileName ־ļ  
	///@return 0 ɹ
	///@return -1 ־ļʧ
	virtual int OpenRequestLog(const char *pszReqLogFileName) = 0;

	///Ӧ־ļ
	///@param pszRspLogFileName Ӧ־ļ  
	///@return 0 ɹ
	///@return -1 ־ļʧ
	virtual int OpenResponseLog(const char *pszRspLogFileName) = 0;


	///û¼
	virtual int ReqUserLogin(CQdpFtdcReqUserLoginField *pReqUserLogin, int nRequestID) = 0;

	///û˳
	virtual int ReqUserLogout(CQdpFtdcReqUserLogoutField *pReqUserLogout, int nRequestID) = 0;

	///û޸
	virtual int ReqUserPasswordUpdate(CQdpFtdcUserPasswordUpdateField *pUserPasswordUpdate, int nRequestID) = 0;

	///¼
	virtual int ReqOrderInsert(CQdpFtdcInputOrderField *pInputOrder, int nRequestID) = 0;

	///
	virtual int ReqOrderAction(CQdpFtdcOrderActionField *pOrderAction, int nRequestID) = 0;

	///ͻϢֵ
	virtual int ReqSetClientMaxSigVol(CQdpFtdcClientMaxSigVolField *pClientMaxSigVol, int nRequestID) = 0;

	///ⱨ¼
	virtual int ReqSpOrderInsert(CQdpFtdcSpInputOrderField *pSpInputOrder, int nRequestID) = 0;

	///ѯ
	virtual int ReqQryOrder(CQdpFtdcQryOrderField *pQryOrder, int nRequestID) = 0;

	///ɽѯ
	virtual int ReqQryTrade(CQdpFtdcQryTradeField *pQryTrade, int nRequestID) = 0;

	///Ͷ˻ѯ
	virtual int ReqQryUserInvestor(CQdpFtdcQryUserInvestorField *pQryUserInvestor, int nRequestID) = 0;

	///Ͷʽ˻ѯ
	virtual int ReqQryInvestorAccount(CQdpFtdcQryInvestorAccountField *pQryInvestorAccount, int nRequestID) = 0;

	///Լѯ
	virtual int ReqQryInstrument(CQdpFtdcQryInstrumentField *pQryInstrument, int nRequestID) = 0;

	///ѯ
	virtual int ReqQryExchange(CQdpFtdcQryExchangeField *pQryExchange, int nRequestID) = 0;

	///Ͷֲֲ߳ѯ
	virtual int ReqQryInvestorPosition(CQdpFtdcQryInvestorPositionField *pQryInvestorPosition, int nRequestID) = 0;

	///
	virtual int ReqSubscribeTopic(CQdpFtdcDisseminationField *pDissemination, int nRequestID) = 0;

	///ѯ
	virtual int ReqQryTopic(CQdpFtdcDisseminationField *pDissemination, int nRequestID) = 0;

	///Ͷʲѯ
	virtual int ReqQryInvestorFee(CQdpFtdcQryInvestorFeeField *pQryInvestorFee, int nRequestID) = 0;

	///Ͷ֤߱ʲѯ
	virtual int ReqQryInvestorMargin(CQdpFtdcQryInvestorMarginField *pQryInvestorMargin, int nRequestID) = 0;

	///ӷʲѯ
	virtual int ReqQrySGEDeferRate(CQdpFtdcQrySGEDeferRateField *pQrySGEDeferRate, int nRequestID) = 0;

	///ͶȨʲѯ
	virtual int ReqQryInvestorOptionFee(CQdpFtdcQryInvestorOptionFeeField *pQryInvestorOptionFee, int nRequestID) = 0;

	///ʰͶֲ߳޶ѯ
	virtual int ReqQryInvestorPositionLimit(CQdpFtdcQryInvestorPositionLimitField *pQryInvestorPositionLimit, int nRequestID) = 0;

	///ʰ潻׻ʲѯ
	virtual int ReqQryExchangeRate(CQdpFtdcQryExchangeRateField *pQryExchangeRate, int nRequestID) = 0;

	///ʵʱѯ
	virtual int ReqQryMarketData(CQdpFtdcQryMarketDataField *pQryMarketData, int nRequestID) = 0;

	///ͨϢѯ
	virtual int ReqQryFrontInfo(CQdpFtdcQryFrontInfoField *pQryFrontInfo, int nRequestID) = 0;

	///ѯ۲ѯ
	virtual int ReqQryForQuote(CQdpFtdcQryForQuoteField *pQryForQuote, int nRequestID) = 0;

	///ѯ¼
	virtual int ReqForQuoteInsert(CQdpFtdcInputForQuoteField *pInputForQuote, int nRequestID) = 0;

	///¼
	virtual int ReqQuoteInsert(CQdpFtdcInputQuoteField *pInputQuote, int nRequestID) = 0;

	///۲
	virtual int ReqQuoteAction(CQdpFtdcQuoteActionField *pQuoteAction, int nRequestID) = 0;

	///¼֤
	virtual int ReqAuthenticate(CQdpFtdcAuthenticateField *pAuthenticate, int nRequestID) = 0;

	///ûɼϢ
	virtual int ReqSubmitUserSystemInfo(CQdpFtdcUserSystemInfoField *pUserSystemInfo, int nRequestID) = 0;

	///MarketData Inserting Request
	virtual int ReqMarketData(CQdpFtdcClientDepthMarketDataField *pClientDepthMarketData, int nRequestID) = 0;

	///Ʒֽˮ
	virtual int ReqSubPrdTradeFlow(CQdpFtdcSpecificInstrumentField *pSpecificInstrument, int nRequestID) = 0;

	///˶Ʒֽˮ
	virtual int ReqUnSubPrdTradeFlow(CQdpFtdcSpecificInstrumentField *pSpecificInstrument, int nRequestID) = 0;

	///׼ QDP_TERT_PRIVATE ˽; QDP_TERT_PUBLIC ;
	virtual int ReqReady(CQdpFtdcFlowStatusField *pFlowStatus, int nRequestID) = 0;
protected:
	~CQdpFtdcTraderApi(){};
};

#endif
